// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'marionette',
    'App',
    'modules/form/section-view',
    'json!modules/new-appointment-request/views/direct/new-appointment-form.json',
    'text!modules/new-appointment-request/views/direct/clinics/templates/_clinic_template.html',
    'modules/new-appointment-request/resources/direct/preferred-date/clinics-time-slots-collections',
    'modules/new-appointment-request/views/direct/no-timeslots-popup/error-message',
    'modules/new-appointment-request/resources/constants',
],
function(
    _,
    Backbone,
    Marionette,
    app,
    SectionView,
    metadata,
    _clinicTemplate,
    SlotsCollection,
    NoAppointmentError,
    constants
) {
    'use strict';


    var messageTemplate = _.template('<p class="custom-message-instructions"><%- customMessageText %></p>');


    return SectionView.extend({

        // hijacking this from the Section View
        collectionEvents: {'change:value': 'checkClinic'},

        templateContext: function() {
            return {
                legend: this.legend,
                customMessageText: this.customMessageText,

            };
        },

        onRender: function() {
            var message = messageTemplate(this.templateContext());
            this.$el.append(message);
        },

        initialize: function() {
            var sectionName = 'appointment-details-clinics-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);
            this.clinicList = this.options.clinicsCollection;
            this.customMessageText = this.options.clinicCustomMessage.get('messageText') || '';

            this.setClinicQuestionModel();
            this.initializeQuestionEventListeners();
        },

        // TODO abstract this into a complete function for testing
        setClinicQuestionModel: function() {
            var clinicQuestionModel = this.collection.get('clinic');

            var clinics = this.clinicList.map(_.bind(function(model) {
                var id = model.get('clinicId');

                return {
                    id: id,
                    text: this.getClinicHtml({
                        clinicName: model.getClinicName(),
                        friendlyName: model.getFriendlyLocationName(),
                        secondaryStopCode: model.get('secondaryStopCode'),
                        VIDEO_STOP_CODE: constants.VIDEO_STOP_CODE,
                        isTelehealthFeaturesEnabled: _.isUndefined(app.disabledFeatures.get('TH_FEATURE_SET')),
                    }),
                    value: id,
                    disabled: false,
                };
            }, this));

            clinicQuestionModel.set('values', clinics);
        },

        /**
         * @param {Backbone.Model} model
         * @return {void}
         */
        checkClinic: function(model) {
            var slots = new SlotsCollection();
            var id = model.get('value');
            var siteCode = this.model.getSiteCode();

            this.slots = slots;
            this.model.unset('clinic');
            this.listenToOnce(this.slots, 'fetch:success', this.fetchSlotsSuccess);

            this.slots.fetchData(siteCode, id);
        },

        getTimeSlots: function(clinicId) {
            if (this.slots) {
                return this.slots.get(clinicId);
            }
            return null;
        },

        fetchSlotsSuccess: function(collection) {
            var model = collection.first() || new Backbone.Model();
            var slots = model.get('appointmentTimeSlot') || [];
            var id;
            var clinic;

            if (slots.length) {
                id = model.id;
                clinic = this.clinicList.get(id);
                return this.model.set('clinic', clinic);
            }
            this.showErrorMessage();
            return null;
        },

        showErrorMessage: function() {
            var popup = new NoAppointmentError({elAfterClose: this.$('legend:first')});
            popup.openPopup();
        },

        /**
         * Generator function to create the clinic text
         * @param {Object} clinic
         * @return {String}
         */
        getClinicHtml: function(clinic) {
            if (!this.clinicTemplate) {
                this.clinicTemplate = _.template(_clinicTemplate);
            }
            return this.clinicTemplate(clinic);
        },
    });
});
